package ru.yandex.search.disk;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.string.NonEmptyValidator;

public enum DiskIndexActionParser
    implements GenericFunction<String, DiskIndexAction, Exception>
{
    INSTANCE(x -> x),
    NON_EMPTY;

    private static final Map<String, DiskIndexAction> ACTION_MAP;
    private final GenericFunction<String, String, Exception> processor;

    static {
        Map<String, DiskIndexAction> map = new HashMap<>();
        for (DiskIndexAction action: DiskIndexAction.values()) {
            map.put(normalize(action.name()), action);
        }

        ACTION_MAP = Collections.unmodifiableMap(map);
    }

    DiskIndexActionParser(final GenericFunction<String, String, Exception> processor) {
        this.processor = processor;
    }

    DiskIndexActionParser() {
        this.processor = NonEmptyValidator.TRIMMED;
    }

    private static String normalize(final String value) {
        return value.trim().toUpperCase(Locale.ROOT).replace('-', '_');
    }

    @Override
    public DiskIndexAction apply(final String s) throws Exception {
        DiskIndexAction action = ACTION_MAP.get(normalize(processor.apply(s)));
        if (action == null) {
            action = DiskIndexAction.UNKNOWN;
        }

        return action;
    }
}
