package ru.yandex.disk.search;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.Parser;
import ru.yandex.util.string.StringUtils;

/**
 * Ava stid example
 * ava:disk:69680:2a0000016784029097a0d58265a839c80626
 */
public final class AvatarSrwKeyConverter implements Parser<String> {
    public static final AvatarSrwKeyConverter
        INSTANCE = new AvatarSrwKeyConverter();

    public static final String PREFIX = "ava:disk";

    private static final String ERROR =
        "Avatar stid expected \"ava:disk:{number}:{hash}\" but got ";

    private AvatarSrwKeyConverter() {
    }

    //CSOFF: MagicNumber
    @Override
    public String parse(final String value) throws BadRequestException {
        if (!isAvatarStid(value)) {
            throw new BadRequestException(ERROR + value);
        }

        String[] split = value.split(":");
        if (split.length < 4) {
            throw new BadRequestException(ERROR + value);
        }

        return StringUtils.concat(split[2], '/', split[3]);
    }
    //CSON: MagicNumber

    public boolean isAvatarStid(final String value) {
        return value != null && value.startsWith(PREFIX);
    }
}
