package ru.yandex.disk.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public enum DiskCvField {
    I2T_KEYWORD,
    FACES_WIDTHS,
    FACES_HEIGHTS,
    FACES,
    WALLPAPER(true),
    BEAUTIFUL(true),
    BAD_QUALITY(true),
    GOOD_QUALITY(true),
    OK_QUALITY(true),
    BAD_QUALITY_V2(true),
    GOOD_QUALITY_V2(true),
    OK_QUALITY_V2(true),
    PAIRWISE_ATTRACTION_0(true),
    PX500("500px_0", true),
    COST_DISK_AETHETIC_0(true),
    MOBILE_PORN(true),
    CHILD_PORN(true),
    GRUESOME(true),
    PERVERSION(true),
    BINARY_PORN(true),
    MULTICLASS_PORN(true),
    PROF_PORN(true),
    PORN_WITH_EROTIC(true);

    public static final List<DiskCvField> CLASSES;

    static {
        List<DiskCvField> classFields =
            Arrays.stream(DiskCvField.values())
                .filter(DiskCvField::classField)
                .collect(Collectors.toList());
        CLASSES = Collections.unmodifiableList(classFields);
    }

    private final boolean isClass;
    private final String fieldName;

    DiskCvField() {
        this(false);
    }

    DiskCvField(final boolean isClass) {
        this.fieldName = name().toLowerCase(Locale.ENGLISH);
        this.isClass = isClass;
    }

    DiskCvField(final String fieldName, final boolean isClass) {
        this.isClass = isClass;
        this.fieldName = fieldName;
    }

    public String fieldName() {
        return fieldName;
    }

    public boolean classField() {
        return isClass;
    }
}
