package ru.yandex.disk.search;

import java.util.Locale;

public enum DiskOcrField {
    OCR_TEXT;

    private final boolean isClass;
    private final String fieldName;

    DiskOcrField() {
        this(false);
    }

    DiskOcrField(final boolean isClass) {
        this.fieldName = name().toLowerCase(Locale.ENGLISH);
        this.isClass = isClass;
    }

    DiskOcrField(final String fieldName, final boolean isClass) {
        this.isClass = isClass;
        this.fieldName = fieldName;
    }

    public String fieldName() {
        return fieldName;
    }

    public boolean classField() {
        return isClass;
    }
}
