package ru.yandex.disk.search.face;

import java.io.IOException;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class ClusterModification implements JsonValue, DeltaItem {
    private final DeltaChangeType changeType;
    private final String clusterId;

    public ClusterModification(
        final DeltaChangeType changeType,
        final String clusterId)
    {
        this.changeType = changeType;
        this.clusterId = clusterId;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("type");
        writer.value(changeType.toString());
        writer.key("cluster_id");
        writer.value(clusterId);
        writer.endObject();
    }

    public static ClusterModification parse(
        final JsonMap map,
        final DeltaChangeType ctype)
        throws JsonException
    {
        return new ClusterModification(ctype, map.getString("cluster_id"));
    }

    @Override
    public boolean cluster() {
        return true;
    }

    @Override
    public ClusterModification asCluster() {
        return this;
    }
}
