package ru.yandex.disk.search.face;

import java.io.IOException;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class FaceModification implements JsonValue, DeltaItem {
    private final DeltaChangeType changeType;
    private final String faceId;
    private final String resourceId;

    public FaceModification(
        final DeltaChangeType changeType,
        final String faceId,
        final String resourceId)
    {
        this.changeType = changeType;
        this.faceId = faceId;
        this.resourceId = resourceId;
    }

    public DeltaChangeType changeType() {
        return changeType;
    }

    public String faceId() {
        return faceId;
    }

    public String resourceId() {
        return resourceId;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("type");
        writer.value(changeType.toString());
        writer.key("face_id");
        writer.value(faceId);
        writer.key("rid");
        writer.value(resourceId);
        writer.endObject();
    }

    public static FaceModification parse(
        final JsonMap map,
        final DeltaChangeType ctype)
        throws JsonException
    {
        return new FaceModification(ctype, map.getString("face_id"), map.getString("rid"));
    }

    @Override
    public boolean face() {
        return true;
    }

    @Override
    public FaceModification asFace() {
        return this;
    }
}
