#pragma once

#include <cv/imageproc/faces/tf_facecropper/face_calculator.h>
#include <cv/library/configthumb/config.h>
#include <cv/library/imageparserlib/imageparser.h>

class TImageParserJniWrapper {
private:
    TImageParserConfig Config;
    TImageParser Parser;
    NImageParserContext::Context Context;
    THolder<NSimilarFaces::TFaceCalculator> FaceCalculator;

public:
    TImageParserJniWrapper(const char* config);

    int Parse(const char* uri, const void *data, size_t size, char** out);
};

extern "C"
int JniWrapperCreateImageParser(const char* config, void** out) noexcept;

extern "C"
void JniWrapperDestroyImageParser(void* instance) noexcept;

extern "C"
int JniWrapperParseImage(
    void* instance,
    const char* uri,
    const char* metainfo,
    const void* data,
    size_t size,
    char** out) noexcept;

