package ru.yandex.search.disk.kali;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class AbstractMedia implements JsonValue {
    protected final String id;
    protected final int width;
    protected final int height;
    protected final Double longitude;
    protected final Double latitude;
    protected final Double altitude;
    protected final String orientation;

    // CSOFF: ParameterNumber
    public AbstractMedia(
        final String id,
        final int width,
        final int height,
        final Double latitude,
        final Double longitude,
        final Double altitude,
        final String orientation)
    {
        this.id = id;
        this.width = width;
        this.height = height;
        this.orientation = orientation;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
    }
    // CSON: ParameterNumber

    public String id() {
        return id;
    }

    public int width() {
        return width;
    }

    public int height() {
        return height;
    }

    public String orientation() {
        return orientation;
    }

    protected void writeFields(final JsonWriterBase writer)
        throws IOException
    {
        writer.key("id");
        writer.value(id());
        writer.key("width");
        writer.value(width);
        writer.key("height");
        writer.value(height);
        writer.key("orientation");
        writer.value(orientation);
        if (latitude != null) {
            writer.key("latitude");
            writer.value(latitude);
        }
        if (longitude != null) {
            writer.key("longitude");
            writer.value(longitude);
        }
        if (altitude != null) {
            writer.key("altitude");
            writer.value(altitude);
        }
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writeFields(writer);
        writer.endObject();
    }
}
