package ru.yandex.search.disk.kali;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.FilterFutureCallback;
import ru.yandex.http.util.PassPayloadThroughFutureCallback;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.DollarJsonWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.util.string.StringUtils;

public class CommitIndexedVersionCallback
    extends FilterFutureCallback<Object>
{
    private static final String INDEXED_PREFIX = "indexed_";

    private final KaliRequestContext context;
    private final String query;
    private final String request;

    public CommitIndexedVersionCallback(
        final FutureCallback<Object> callback,
        final KaliRequestContext context,
        final KaliRequestDoc doc)
        throws HttpException
    {
        super(callback);
        this.context = context;
        QueryConstructor query =
            new QueryConstructor("/modify?indexed-version");
        context.appendParams(query, doc);
        this.query = query.toString();

        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = new DollarJsonWriter(sbw)) {
            writer.startObject();
            writer.key("prefix");
            writer.value(context.prefix());
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key("id");
            writer.value(StringUtils.concat(INDEXED_PREFIX, doc.id()));
            writer.key("resource_id");
            writer.value(StringUtils.concat(INDEXED_PREFIX, doc.resourceId()));
            writer.key("indexed_version");
            writer.value(doc.version());
            writer.key("indexed_action_type");
            writer.value(doc.kaliActionType().toString());
            writer.endObject();
            writer.endArray();
            writer.endObject();
        } catch (IOException e) {
            throw new ServiceUnavailableException(e);
        }
        request = sbw.toString();
    }

    @Override
    @SuppressWarnings("FutureReturnValueIgnored")
    public void completed(final Object response) {
        context.indexerClient().execute(
            context.kali().config().indexerConfig().host(),
            new BasicAsyncRequestProducerGenerator(
                query,
                request,
                context.kali().indexerContentType()),
            EmptyAsyncConsumerFactory.INSTANCE,
            context.session().listener().createContextGeneratorFor(
                context.indexerClient()),
            new PassPayloadThroughFutureCallback<>(response, callback));
    }
}

