package ru.yandex.search.disk.kali;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.AsyncLockHolder;
import ru.yandex.http.util.ClosingFutureCallback;
import ru.yandex.http.util.PassPayloadThroughFutureCallback;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.DollarJsonWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.QueryConstructor;

public class DeleteDocTask extends KaliTask {
    private final String query;
    private final String request;
    private final KaliRequestDoc doc;
    private final FutureCallback<Object> callback;

    public DeleteDocTask(
        final AsyncLockHolder lock,
        final KaliRequestContext context,
        final KaliRequestDoc doc)
        throws HttpException
    {
        super(context, lock);

        this.doc = doc;
        QueryConstructor query = new QueryConstructor("/delete?", false);
        context.appendParams(query, doc);
        this.query = query.toString();

        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = new DollarJsonWriter(sbw)) {
            context.prologue(writer, doc, false);
            context.epilogue(writer);
        } catch (IOException e) {
            throw new ServiceUnavailableException(e);
        }
        request = sbw.toString();

        callback =
            new CommitIndexedVersionCallback(
                new ClosingFutureCallback<>(
                    context.callback().newCallback(),
                    lock),
                context,
                doc);
    }

    @Override
    public void run() {
        context.indexerClient().execute(
            context.kali().config().indexerConfig().host(),
            new BasicAsyncRequestProducerGenerator(
                query,
                request,
                context.kali().indexerContentType()),
            EmptyAsyncConsumerFactory.INSTANCE,
            context.session().listener().createContextGeneratorFor(
                context.indexerClient()),
            new PassPayloadThroughFutureCallback<>(doc, callback));
    }
}

