package ru.yandex.search.disk.kali;

import java.util.logging.Level;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;

public class DocumentErrorHandler {
    private final KaliRequestContext requestContext;

    public DocumentErrorHandler(final KaliRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void handle(
        final String field,
        final JsonMap doc,
        final JsonException e)
    {
        requestContext.kali().documentSerializationFailed();
        requestContext.session().logger().log(
            Level.WARNING,
            "Malformed field \"" + field + "\" in document meta:\n"
            + JsonType.HUMAN_READABLE.toString(doc),
            e);
    }
}

