package ru.yandex.search.disk.kali;

import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.http.util.AbstractFilterMultiFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.parser.uri.QueryConstructor;

public class EldersCleanupCallback
    extends AbstractFilterMultiFutureCallback<Object, Object>
{
    private final KaliRequestContext context;
    private final KaliCleanupCallback cleanupCallback;
    private final String query;

    public EldersCleanupCallback(
        final KaliRequestContext context,
        final List<KaliRequestDoc> docs)
        throws HttpException
    {
        super(context.callback());
        this.context = context;
        cleanupCallback = new KaliCleanupCallback(context, docs);
        QueryConstructor query = new QueryConstructor(
            "/search-kali?json-type=dollar&get=id,version,resource_id");
        query.append("IO_PRIO", context.ioPrio());
        query.append("prefix", context.prefix());
        query.append(
            "text",
            "type:* AND (resource_id:[0 TO " + docs.get(0).resourceId()
            + "] OR resource_id:[" + docs.get(docs.size() - 1).resourceId()
            + " TO z])");
        query.append("length", Kali.MAX_CLEANUP_REMOVE_TASKS);
        this.query = query.toString();
    }

    @Override
    public void completed(final Object result) {
        context.searcherClient().execute(
            context.kali().config().searcherConfig().host(),
            new BasicAsyncRequestProducerGenerator(query),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            context.session().listener()
                .createContextGeneratorFor(context.searcherClient()),
            cleanupCallback);
    }
}

