package ru.yandex.search.disk.kali;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;

public class Image extends AbstractMedia {
    private final long uid;
    private final String stid;
    private final String previewStid;
    private final String resourceId;

    public Image(
        final KaliDocumentContext doc,
        final int width,
        final int height,
        final Double latitude,
        final Double longitude,
        final Double altitude,
        final String orientation)
    {
        super(doc.id(), width, height, latitude, longitude, altitude, orientation);

        resourceId = doc.resourceId();

        this.uid = doc.owner();
        this.stid = doc.stid();
        this.previewStid = doc.previewStid();
    }

    public void writeFaceJson(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("id");
        writer.value(id());
        writer.key("resource_id");
        writer.value(resourceId);
        writer.key("uid");
        writer.value(uid);
        writer.key("stid");
        writer.value(stid);
        writer.key("preview_stid");
        writer.value(previewStid);
        writer.endObject();
    }

    public long uid() {
        return uid;
    }

    public String stid() {
        return stid;
    }

    public String previewStid() {
        return previewStid;
    }

    public String resourceId() {
        return resourceId;
    }

    @Override
    public String toString() {
        return "Image{"
            + "id='" + id + '\''
            + ", width=" + width
            + ", height=" + height
            + ", orientation='" + orientation + '\''
            + '}';
    }
}
