package ru.yandex.search.disk.kali;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.DoubleFutureCallback;
import ru.yandex.http.util.FilterFutureCallback;
import ru.yandex.http.util.PassPayloadThroughFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.uri.QueryConstructor;

public class ImageCallback extends FilterFutureCallback<Object> {
    private final KaliDocumentContext doc;
    private final KaliRequestContext context;
    private final AbstractMedia image;

    public ImageCallback(
        final FutureCallback<Object> callback,
        final AbstractMedia image,
        final KaliDocumentContext doc)
    {
        super(callback);
        this.doc = doc;
        this.context = doc.requestContext();
        this.image = image;
    }

    // CSOFF: ParameterNumber
    private void spawnOcrProxyRequest(
        final QueryConstructor query,
        final List<URI> callbacks,
        final List<URI> faceCallbacks,
        final String peachQueue,
        final FutureCallback<Object> callback)
        throws BadRequestException
    {
        context.appendParams(query, doc);
        query.append("stid", doc.stid());
        if (doc.previewStid() != null) {
            query.append("preview-stid", doc.previewStid());
        }
        for (URI callbackUri: callbacks) {
            query.append("callback", callbackUri.toString());
        }

        for (URI callbackUri: faceCallbacks) {
            query.append("face_callback", callbackUri.toString());
        }

        query.append("zoo-queue-id", context.cgiZooQueueId());

        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(query.toString());
        producerGenerator.addHeader(YandexHeaders.X_PEACH_QUEUE, peachQueue);
        Kali kali = context.kali();
        AsyncClient client =
            kali.ocrProxyClient().adjust(context.session().context());
        client.execute(
            kali.config().ocrProxyConfig().host(),
            producerGenerator,
            EmptyAsyncConsumerFactory.OK,
            context.session().listener().createContextGeneratorFor(client),
            callback);
    }
    // CSON: ParameterNumber

    @Override
    public void completed(final Object response) {
        DoubleFutureCallback<Object, Object> callback =
            new DoubleFutureCallback<>(
                new PassPayloadThroughFutureCallback<>(
                    image,
                    this.callback));

        String ocrQuery;
        String ocrQueue;
        String cvQuery;
        String cvQueue;
        if (doc.kaliActionType() == KaliActionType.REINDEX) {
            ocrQuery = "/ocr-reindex?";
            ocrQueue = "ocr-reindex";
            cvQuery = "/cv-reindex?";
            cvQueue = "cv-reindex";
        } else {
            ocrQuery = "/ocr?";
            ocrQueue = "ocr";
            cvQuery = "/cv?";
            cvQueue = "cv";
        }
        try {
            spawnOcrProxyRequest(
                new QueryConstructor(ocrQuery, false),
                context.ocrCallbacks(),
                Collections.emptyList(),
                ocrQueue,
                callback.first());

            List<URI> faceCallbacks = Collections.emptyList();
            if (context.faceProcessor() != null && image instanceof Image) {
                URI uri = context.faceProcessor().processUpdate((Image) image, doc);
                if (uri != null) {
                    faceCallbacks = Collections.singletonList(uri);
                }
            }
            spawnOcrProxyRequest(
                new QueryConstructor(cvQuery, false),
                context.cvCallbacks(),
                faceCallbacks,
                cvQueue,
                callback.second());
        } catch (BadRequestException | URISyntaxException e) {
            failed(e);
        }
    }
}

