package ru.yandex.search.disk.kali;

import java.io.File;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.disk.kali.config.ImmutableKaliFaceConfig;

public class ImmutableKaliConfig
    extends ImmutableHttpProxyConfig
    implements KaliConfig
{
    private final ImmutableURIConfig djfsConfig;
    private final ImmutableHttpHostConfig tikaiteConfig;
    private final int bodyTextLimit;
    private final ImmutableHttpHostConfig searcherConfig;
    private final ImmutableHttpHostConfig indexerConfig;
    private final ImmutableHttpHostConfig ocrProxyConfig;
    private final ImmutableHttpTargetConfig callbacksConfig;
    private final ImmutableKaliFaceConfig faceConfig;
    private final String callbacksQueue;
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    private final String djfsTvmClientId;
    private final String tikaiteTvmClientId;
    private final String unistorageTvmClientId;
    private final File peronsalUserLimits;

    public ImmutableKaliConfig(final KaliConfig config)
        throws ConfigException
    {
        super(config);
        forceTvm2ServiceConfig();

        djfsConfig = new ImmutableURIConfig(config.djfsConfig());
        tikaiteConfig = new ImmutableHttpHostConfig(config.tikaiteConfig());
        bodyTextLimit = BODY_TEXT_LIMIT.validate(config.bodyTextLimit());
        searcherConfig = new ImmutableHttpHostConfig(config.searcherConfig());
        indexerConfig = new ImmutableHttpHostConfig(config.indexerConfig());
        ocrProxyConfig = new ImmutableHttpHostConfig(config.ocrProxyConfig());
        faceConfig = new ImmutableKaliFaceConfig(config.faceConfig());
        callbacksConfig =
            new ImmutableHttpTargetConfig(config.callbacksConfig());
        callbacksQueue = CALLBACKS_QUEUE.validate(config.callbacksQueue());
        tvm2ClientConfig =
            new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());
        djfsTvmClientId =
            DJFS_TVM_CLIENT_ID.validate(config.djfsTvmClientId());
        tikaiteTvmClientId =
            TIKAITE_TVM_CLIENT_ID.validate(config.tikaiteTvmClientId());
        unistorageTvmClientId =
            UNISTORAGE_TVM_CLIENT_ID.validate(config.unistorageTvmClientId());
        peronsalUserLimits = config.peronsalUserLimits();
    }

    @Override
    public ImmutableURIConfig djfsConfig() {
        return djfsConfig;
    }

    @Override
    public ImmutableHttpHostConfig tikaiteConfig() {
        return tikaiteConfig;
    }

    @Override
    public int bodyTextLimit() {
        return bodyTextLimit;
    }

    @Override
    public ImmutableKaliFaceConfig faceConfig() {
        return faceConfig;
    }

    @Override
    public ImmutableHttpHostConfig searcherConfig() {
        return searcherConfig;
    }

    @Override
    public ImmutableHttpHostConfig indexerConfig() {
        return indexerConfig;
    }

    @Override
    public ImmutableHttpHostConfig ocrProxyConfig() {
        return ocrProxyConfig;
    }

    @Override
    public ImmutableHttpTargetConfig callbacksConfig() {
        return callbacksConfig;
    }

    @Override
    public String callbacksQueue() {
        return callbacksQueue;
    }

    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Override
    public String djfsTvmClientId() {
        return djfsTvmClientId;
    }

    @Override
    public String tikaiteTvmClientId() {
        return tikaiteTvmClientId;
    }

    @Override
    public String unistorageTvmClientId() {
        return unistorageTvmClientId;
    }

    @Override
    public File peronsalUserLimits() {
        return peronsalUserLimits;
    }
}

