package ru.yandex.search.disk.kali;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.util.AbstractFilterMultiFutureCallback;
import ru.yandex.http.util.ServerException;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class KaliCleanupCallback
    extends AbstractFilterMultiFutureCallback<JsonObject, Object>
{
    private final KaliRequestContext context;
    private final List<KaliRequestDoc> docs;
    private final long version;

    public KaliCleanupCallback(
        final KaliRequestContext context,
        final List<KaliRequestDoc> docs)
        throws HttpException
    {
        super(context.callback());
        this.context = context;
        this.docs = docs;
        version = context.session().params().getLong("version");
    }

    @Override
    public void completed(final JsonObject result) {
        Set<String> docsResources = new HashSet<>(docs.size() << 1);
        for (KaliRequestDoc doc: docs) {
            docsResources.add(doc.resourceId());
        }
        try {
            long hitsCount = result.get("hitsCount").asLong();
            JsonList docs = result.get("hitsArray").asList();
            List<KaliRequestDoc> docsForRemoval = new ArrayList<>(docs.size());
            for (JsonObject docObject: docs) {
                KaliRequestDoc doc = new KaliRequestDoc(
                    KaliActionType.REMOVE,
                    docObject.asMap());
                if (doc.version() < version
                    && !docsResources.contains(doc.resourceId()))
                {
                    docsForRemoval.add(doc);
                }
            }
            List<KaliRequestDoc> docsForUpdate;
            if (hitsCount > docs.size()) {
                context.registerException(
                    new ServerException(
                        HttpStatus.SC_INSUFFICIENT_STORAGE,
                        "Delete docs count is too large ("
                            + hitsCount + ") "
                            + "request retry is required to "
                            + "process next batch"));
                docsForUpdate = Collections.emptyList();
            } else if (context.cleanupType() == KaliCleanupType.OUTER) {
                docsForUpdate = Collections.emptyList();
            } else {
                docsForUpdate = this.docs;
            }
            context.kali().handleUpdate(
                context,
                docsForUpdate,
                docsForRemoval);
        } catch (HttpException e) {
            failed(e);
        } catch (JsonException e) {
            failed(
                new ServiceUnavailableException(
                    "Failed to deserialize lucene response",
                    e));
        }
    }
}
