package ru.yandex.search.disk.kali;

import java.io.File;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveValidator;
import ru.yandex.search.disk.kali.config.KaliFaceConfig;

public interface KaliConfig extends HttpProxyConfig {
    ParameterConfig<Integer> BODY_TEXT_LIMIT = new ParameterConfig<>(
        "body-text-limit",
        Integer::valueOf,
        PositiveValidator.instance());

    ParameterConfig<String> CALLBACKS_QUEUE = new ParameterConfig<>(
        "queue",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);

    ParameterConfig<String> DJFS_TVM_CLIENT_ID = new ParameterConfig<>(
        "djfs.tvm-client-id",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);

    ParameterConfig<String> TIKAITE_TVM_CLIENT_ID = new ParameterConfig<>(
        "tikaite.tvm-client-id",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);

    ParameterConfig<String> UNISTORAGE_TVM_CLIENT_ID = new ParameterConfig<>(
        "tikaite.unistorage-client-id",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);

    URIConfig djfsConfig();

    HttpHostConfig tikaiteConfig();

    int bodyTextLimit();

    HttpHostConfig searcherConfig();

    HttpHostConfig indexerConfig();

    HttpHostConfig ocrProxyConfig();

    HttpTargetConfig callbacksConfig();

    KaliFaceConfig faceConfig();

    String callbacksQueue();

    Tvm2ClientConfig tvm2ClientConfig();

    String djfsTvmClientId();

    String tikaiteTvmClientId();

    String unistorageTvmClientId();

    /**
     * File with limitations for special users
     * @return
     */
    File peronsalUserLimits();
}

