package ru.yandex.search.disk.kali;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class KaliConfigBuilder
    extends AbstractKaliConfigBuilder<KaliConfigBuilder>
{
    public KaliConfigBuilder() {
        super(KaliConfigDefaults.INSTANCE);
    }

    public KaliConfigBuilder(final KaliConfig config) {
        super(config);
    }

    public KaliConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, KaliConfigDefaults.INSTANCE);
    }

    public KaliConfigBuilder(final IniConfig config, final KaliConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public KaliConfigBuilder self() {
        return this;
    }

    public ImmutableKaliConfig build() throws ConfigException {
        return new ImmutableKaliConfig(this);
    }
}

