package ru.yandex.search.disk.kali;

import java.io.File;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.search.disk.kali.config.KaliFaceConfig;
import ru.yandex.search.disk.kali.config.KaliFaceConfigDefaults;

public class KaliConfigDefaults
    extends HttpProxyConfigDefaults
    implements KaliConfig
{
    public static final KaliConfigDefaults INSTANCE = new KaliConfigDefaults();

    private static final int DEFAULT_BODY_TEXT_LIMIT = 640000;

    protected KaliConfigDefaults() {
    }

    @Override
    public URIConfig djfsConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig tikaiteConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public int bodyTextLimit() {
        return DEFAULT_BODY_TEXT_LIMIT;
    }

    @Override
    public HttpHostConfig searcherConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig indexerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig ocrProxyConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpTargetConfig callbacksConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public String callbacksQueue() {
        return null;
    }

    @Override
    public Tvm2ClientConfig tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public String djfsTvmClientId() {
        return null;
    }

    @Override
    public String tikaiteTvmClientId() {
        return null;
    }

    @Override
    public String unistorageTvmClientId() {
        return null;
    }

    @Override
    public KaliFaceConfig faceConfig() {
        return KaliFaceConfigDefaults.INSTANCE;
    }

    @Override
    public File peronsalUserLimits() {
        return null;
    }
}

