package ru.yandex.search.disk.kali;

import ru.yandex.disk.search.DiskField;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.CgiParams;

public class KaliDocumentContext extends KaliRequestDoc {
    private final KaliRequestContext requestContext;
    private final JsonMap doc;
    private final DiskDocumentType type;
    private final String stid;
    private final String previewStid;
    private final String mimetype;
    private final long watchdogVersion;

    public KaliDocumentContext(
        final KaliRequestContext requestContext,
        final JsonMap doc,
        final DiskDocumentType type)
        throws JsonException
    {
        super(requestContext.kaliActionType(), doc);
        this.requestContext = requestContext;
        this.doc = doc;
        this.type = type;
        stid = type.stid(doc);
        previewStid = doc.getString(DiskField.PREVIEW_STID.fieldName(), null);
        mimetype = doc.getString(DiskField.MIMETYPE.fieldName(), "");
        CgiParams params = requestContext.session().params();
        try {
            if (params.getBoolean("watchdog", false)) {
                watchdogVersion = params.getLong("version");
            } else {
                watchdogVersion = -1L;
            }
        } catch (BadRequestException e) {
            throw new JsonException(e);
        }
    }

    public KaliRequestContext requestContext() {
        return requestContext;
    }

    public JsonMap doc() {
        return doc;
    }

    public DiskDocumentType type() {
        return type;
    }

    public String stid() {
        return stid;
    }

    public String previewStid() {
        return previewStid;
    }

    public String mimetype() {
        return mimetype;
    }

    @Override
    public long version() {
        if (watchdogVersion >= 0L) {
            return watchdogVersion;
        } else {
            return super.version();
        }
    }
}

