package ru.yandex.search.disk.kali;

import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeLongValidator;
import ru.yandex.parser.string.ValuesStorage;

public class KaliRequestDoc {
    private static final String ID = "id";
    private static final String RESOURCE_ID = "resource_id";
    private static final String VERSION = "version";

    private final KaliActionType kaliActionType;
    private final String id;
    private final String resourceId;
    private final long owner;
    private final long version;

    public <E extends Exception> KaliRequestDoc(
        final KaliActionType kaliActionType,
        final ValuesStorage<E> params)
        throws E
    {
        this.kaliActionType = kaliActionType;
        id = params.get(ID, NonEmptyValidator.INSTANCE);
        resourceId = params.get(RESOURCE_ID, NonEmptyValidator.INSTANCE);
        try {
            owner = Long.parseLong(
                resourceId.substring(0, resourceId.indexOf(':')));
        } catch (RuntimeException e) {
            throw params.parseFailedException(RESOURCE_ID, resourceId, e);
        }
        version = params.get(VERSION, NonNegativeLongValidator.INSTANCE);
    }

    public KaliActionType kaliActionType() {
        return kaliActionType;
    }

    public String id() {
        return id;
    }

    public String resourceId() {
        return resourceId;
    }

    public long owner() {
        return owner;
    }

    public long version() {
        return version;
    }
}

