package ru.yandex.search.disk.kali;

import ru.yandex.concurrent.AsyncLockHolder;

public abstract class KaliTask implements Runnable {
    protected final KaliRequestContext context;
    private final AsyncLockHolder lock;

    KaliTask(final KaliRequestContext context, final AsyncLockHolder lock) {
        this.context = context;
        this.lock = lock;
    }

    public void execute() {
        execute(this);
    }

    public void execute(final Runnable task) {
        int lockQueueSize = lock.lock(task);
        context.kali().lockQueueSize(lockQueueSize);
        context.session().logger().info(
            "Async lock taken for " + lock.lockKey()
            + ", queue size: " + lockQueueSize);
    }
}

