package ru.yandex.search.disk.kali;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.AsyncLockHolder;
import ru.yandex.http.util.ClosingFutureCallback;
import ru.yandex.http.util.server.HttpServer;

public abstract class KaliUpdateTask extends KaliTask {
    protected final KaliDocumentContext doc;
    protected final FutureCallback<Object> callback;
    private final VersionCheckTask versionCheckTask;

    protected KaliUpdateTask(
        final AsyncLockHolder lock,
        final KaliDocumentContext doc)
        throws HttpException
    {
        super(doc.requestContext(), lock);
        this.doc = doc;
        FutureCallback<Object> callback = new ClosingFutureCallback<>(
            context.callback().newCallback(),
            lock);
        this.callback =
            new CommitIndexedVersionCallback(callback, context, doc);
        versionCheckTask = new VersionCheckTask(context, callback, this);
    }

    public KaliDocumentContext doc() {
        return doc;
    }

    @Override
    public void execute() {
        execute(versionCheckTask);
    }

    @Override
    public String toString() {
        return context.session().context()
            .getAttribute(HttpServer.SESSION_ID).toString();
    }
}

