package ru.yandex.search.disk.kali;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Collection;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.concurrent.AsyncLock;
import ru.yandex.concurrent.LockStorage;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.CgiParams;

public class LocksStatusHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final LockStorage<String, AsyncLock> lockStorage;

    public LocksStatusHandler(
        final LockStorage<String, AsyncLock> lockStorage)
    {
        this.lockStorage = lockStorage;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        CgiParams params = new CgiParams(request);
        Charset charset = CharsetUtils.acceptedCharset(request);
        CharsetEncoder encoder = charset.newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonWriter writer = JsonTypeExtractor.HUMAN_READABLE
                .extract(params)
                .create(new OutputStreamWriter(baos, encoder)))
        {
            writer.startArray();
            lockStorage.traverse(new Visitor(writer));
            writer.endArray();
        }
        exchange.getResponse().setEntity(
            new NByteArrayEntity(baos.toByteArray(),
                ContentType.APPLICATION_JSON.withCharset(charset)));
        exchange.submitResponse();
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public String toString() {
        return
            "Prints server status: amount of active workers, connections etc.";
    }

    private static class Visitor
        implements LockStorage.Visitor<String, AsyncLock, IOException>,
            AsyncLock.Visitor<IOException>
    {
        private final JsonWriter writer;

        Visitor(final JsonWriter writer) {
            this.writer = writer;
        }

        @Override
        public void visit(
            final String key,
            final int refs,
            final AsyncLock lock)
            throws IOException
        {
            writer.startObject();
            writer.key("key");
            writer.value(key);
            writer.key("refs");
            writer.value(refs);
            writer.key("locks");
            lock.traverse(this);
            writer.endObject();
        }

        @Override
        public void visit(
            final Runnable activeTask,
            final Collection<Runnable> queuedTasks)
            throws IOException
        {
            writer.startObject();
            writer.key("active-task");
            writer.value(activeTask.toString());
            writer.key("queued-tasks-count");
            writer.value(queuedTasks.size());
            writer.key("queued-tasks");
            writer.startArray();
            for (Runnable task: queuedTasks) {
                writer.value(task.toString());
            }
            writer.endArray();
            writer.endObject();
        }
    }
}

