package ru.yandex.search.disk.kali;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.concurrent.AsyncLockHolder;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.DollarJsonWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.QueryConstructor;

public class UpdateDirTask extends KaliUpdateTask {
    private final String query;
    private final String request;

    public UpdateDirTask(
        final AsyncLockHolder lock,
        final KaliDocumentContext doc)
        throws HttpException, IOException, JsonException
    {
        super(lock, doc);

        QueryConstructor query = new QueryConstructor("/modify?dir");
        context.appendParams(query, doc);
        this.query = query.toString();

        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = new DollarJsonWriter(sbw)) {
            context.prologue(writer, doc);
            doc.type().writeDocument(
                doc.doc(),
                writer,
                new DocumentErrorHandler(context));
            context.epilogue(writer);
        }
        request = sbw.toString();
    }

    @Override
    public void run() {
        context.indexerClient().execute(
            context.kali().config().indexerConfig().host(),
            new BasicAsyncRequestProducerGenerator(
                query,
                request,
                context.kali().indexerContentType()),
            EmptyAsyncConsumerFactory.ANY_GOOD,
            context.session().listener().createContextGeneratorFor(
                context.indexerClient()),
            callback);
    }
}

