package ru.yandex.search.disk.kali;

import org.apache.http.HttpException;

import ru.yandex.concurrent.AsyncLockHolder;
import ru.yandex.disk.search.DiskParams;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.server.UpstreamStaterFutureCallback;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.parser.uri.QueryConstructor;

public class UpdateFileTask extends KaliUpdateTask {
    private final String query;

    public UpdateFileTask(
        final AsyncLockHolder lock,
        final KaliDocumentContext doc)
        throws HttpException
    {
        super(lock, doc);

        int bodyTextLimit = context.kali().bodyTextLimit(doc.requestContext().prefix());
        if (bodyTextLimit != context.kali().config().bodyTextLimit()) {
            context.session().logger().info("User body_text is limited " + bodyTextLimit);
        }
        QueryConstructor query =
            new QueryConstructor("/disk/handler?json-type=dollar");
        query.append("limit", bodyTextLimit);
        query.append("stid", doc.stid());
        String mimetype = doc.mimetype();
        if (!mimetype.isEmpty()) {
            query.append("mimetype", mimetype);
        }
        this.query = query.toString();
    }

    @Override
    public void run() {
        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(query);
        producerGenerator.addHeader(
            YandexHeaders.X_YA_SERVICE_TICKET,
            context.kali().tikaiteTvm2Ticket());
        producerGenerator.addHeader(
            YandexHeaders.X_SRW_SERVICE_TICKET,
            context.kali().unistorageTvm2Ticket());
        producerGenerator.addHeader(DiskParams.DISK_X_SRW_NAMESPACE);
        producerGenerator.addHeader(DiskParams.DISK_X_SRW_KEY_TYPE);
        producerGenerator.addHeader(YandexHeaders.X_SRW_KEY, doc.stid());
        AsyncClient client =
            context.kali().tikaiteClient().adjust(context.session().context());
        client.execute(
            context.kali().config().tikaiteConfig().host(),
            producerGenerator,
            JsonAsyncTypesafeDomConsumerFactory.OK,
            context.session().listener().createContextGeneratorFor(client),
            new UpstreamStaterFutureCallback<>(
                new TikaiteCallback(callback, doc),
                context.kali().tikaiteStater()));
    }
}

