package ru.yandex.search.disk.kali;

import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.FilterFutureCallback;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class VersionCallback extends FilterFutureCallback<JsonObject> {
    private static final String DOCUMENT = "Document with version ";

    private final KaliRequestContext context;
    private final KaliUpdateTask indexationTask;

    public VersionCallback(
        final FutureCallback<Object> callback,
        final KaliRequestContext context,
        final KaliUpdateTask indexationTask)
    {
        super(callback);
        this.context = context;
        this.indexationTask = indexationTask;
    }

    @Override
    public void completed(final JsonObject result) {
        long version = indexationTask.doc().version() - 1;
        String indexedActionType = null;
        try {
            JsonList docs = result.get("hitsArray").asList();
            if (!docs.isEmpty()) {
                JsonMap doc = docs.get(0).asMap();
                version = doc.getLong("indexed_version");
                indexedActionType =
                    doc.get("indexed_action_type").asStringOrNull();
            }
        } catch (JsonException e) {
            context.session().logger().log(
                Level.WARNING,
                "Something went terribly wrong",
                e);
            failed(new BadRequestException(e));
            return;
        }

        if (KaliActionType.REMOVE.toString().equals(indexedActionType)) {
            if (indexationTask.doc().version() > version) {
                context.session().logger().warning(
                    DOCUMENT + version
                    + " already deleted, can't " + context.kaliActionType());
                context.kali().malformedActionOrder();
                callback.completed(result);
            } else {
                context.session().logger().info(
                    DOCUMENT + version
                    + " already deleted, skipping " + context.kaliActionType());
                context.kali().requestSkipped();
                callback.completed(result);
            }
        } else if (version > indexationTask.doc().version()) {
            context.session().logger().info(
                DOCUMENT + version
                + " already present, skipping " + context.kaliActionType());
            context.kali().requestSkipped();
            callback.completed(result);
        } else {
            // Fine, this is the newest version of the document
            context.kali().requestAccepted();
            indexationTask.run();
        }
    }
}

