package ru.yandex.search.disk.kali;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.request.util.SearchRequestText;
import ru.yandex.util.string.StringUtils;

public class VersionCheckTask implements Runnable {
    private final KaliRequestContext context;
    private final FutureCallback<Object> callback;
    private final KaliUpdateTask indexationTask;
    private final String query;

    public VersionCheckTask(
        final KaliRequestContext context,
        final FutureCallback<Object> callback,
        final KaliUpdateTask indexationTask)
        throws HttpException
    {
        this.context = context;
        this.callback = callback;
        this.indexationTask = indexationTask;
        QueryConstructor query = new QueryConstructor(
            "/search-kali?json-type=dollar"
            + "&get=indexed_version,indexed_action_type");
        query.append("IO_PRIO", context.ioPrio());
        query.append("prefix", context.prefix());
        query.append(
            "text",
            StringUtils.concat(
                "resource_id:\"indexed_",
                SearchRequestText.quoteEscape(
                    indexationTask.doc().resourceId()),
                '"'));
        CgiParams params = context.session().params();
        query.copyIfPresent(params, "check-copyness");
        query.copyIfPresent(params, "watchdog");
        this.query = query.toString();
    }

    @Override
    public void run() {
        context.searcherClient().execute(
            context.kali().config().searcherConfig().host(),
            new BasicAsyncRequestProducerGenerator(query),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            context.session().listener().createContextGeneratorFor(
                context.searcherClient()),
            new VersionCallback(callback, context, indexationTask));
    }

    @Override
    public String toString() {
        return indexationTask.toString();
    }
}

