package ru.yandex.search.disk.kali.config;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractKaliFaceConfigBuilder
    <T extends AbstractKaliFaceConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements KaliFaceConfig
{
    private boolean enabled;
    private String callbackBaseUri;
    private String faceQueue;

    protected AbstractKaliFaceConfigBuilder(final KaliFaceConfig config) {
        super(config);

        enabled(config.enabled());
        callbackBaseUri(config.callbackBaseUri());
        faceQueue(config.faceQueue());
    }

    protected AbstractKaliFaceConfigBuilder(
        final IniConfig config,
        final KaliFaceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        this.enabled = config.getBoolean("enabled", defaults.enabled());
        this.callbackBaseUri =
            config.getString("callback-base-uri", defaults.callbackBaseUri());
        this.faceQueue = config.getString("face-queue", defaults.faceQueue());
    }

    @Override()
    public boolean enabled() {
        return enabled;
    }

    public T enabled(final boolean value) {
        this.enabled = value;
        return self();
    }

    @Override()
    public String callbackBaseUri() {
        return callbackBaseUri;
    }

    public T callbackBaseUri(final String value) {
        this.callbackBaseUri = value;
        return self();
    }

    @Override()
    public String faceQueue() {
        return faceQueue;
    }

    public T faceQueue(final String value) {
        this.faceQueue = value;
        return self();
    }

    @Override
    public abstract T self();
}
