package ru.yandex.search.disk.kali.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableKaliFaceConfig
    extends ImmutableHttpHostConfig
    implements KaliFaceConfig
{
    private final boolean enabled;
    private final String callbackBaseUri;
    private final String faceQueue;

    public ImmutableKaliFaceConfig(
        final KaliFaceConfig config)
        throws ConfigException
    {
        super(config);

        this.enabled = config.enabled();
        this.callbackBaseUri = config.callbackBaseUri();
        this.faceQueue = config.faceQueue();
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public String callbackBaseUri() {
        return callbackBaseUri;
    }

    @Override
    public String faceQueue() {
        return faceQueue;
    }
}
