package ru.yandex.search.disk.kali.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class KaliFaceConfigBuilder
     extends AbstractKaliFaceConfigBuilder<KaliFaceConfigBuilder>
{
    public KaliFaceConfigBuilder() {
        this(KaliFaceConfigDefaults.INSTANCE);
    }

    public KaliFaceConfigBuilder(final KaliFaceConfig config) {
        super(config);
    }

    public KaliFaceConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, KaliFaceConfigDefaults.INSTANCE);
    }

    public KaliFaceConfigBuilder(
        final IniConfig config,
        final KaliFaceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableKaliFaceConfig build() throws ConfigException {
        return new ImmutableKaliFaceConfig(
            this);
    }

    @Override
    public KaliFaceConfigBuilder self() {
        return this;
    }
}
