package ru.yandex.search.disk.kali.config;

import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.disk.kali.ImmutableKaliConfig;

public class PersonalIndexationLimits {
    private final Map<Long, Integer> tikaiteBodyTextLimit;
    private final ImmutableKaliConfig config;

    public PersonalIndexationLimits(final ImmutableKaliConfig config) throws IOException  {
        this.config = config;
        if (config.peronsalUserLimits() != null) {
            try {
                JsonMap root = TypesafeValueContentHandler.parse(
                    new FileReader(config.peronsalUserLimits(), StandardCharsets.UTF_8)).asMap();
                Map<Long, Integer> tikaiteBodyTextLimit = new LinkedHashMap<>();
                for (Map.Entry<String, JsonObject> entry: root.entrySet()) {
                    Long user = Long.parseLong(entry.getKey());
                    JsonMap userConfig = entry.getValue().asMap();
                    LimitType limitType = userConfig.getEnum(LimitType.class, "limit_type");
                    if (limitType == LimitType.BODY_TEXT) {
                        int limitValue = userConfig.getInt("limit_value");
                        tikaiteBodyTextLimit.put(user, limitValue);
                    }
                }
                this.tikaiteBodyTextLimit = Collections.unmodifiableMap(tikaiteBodyTextLimit);
            } catch (JsonException | NumberFormatException je) {
                throw new IOException("Failed to load personal limits for users", je);
            }
        } else {
            tikaiteBodyTextLimit = Collections.emptyMap();
        }
    }

    public int tikaiteBodyTextLimit(final Long user) {
        return tikaiteBodyTextLimit.getOrDefault(user, config.bodyTextLimit());
    }

    private enum LimitType {
        BODY_TEXT
    }
}
