package ru.yandex.ocr.proxy;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractOcrProxyConfigBuilder
    <T extends AbstractOcrProxyConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements OcrProxyConfig
{
    private HttpHostConfigBuilder ocraasConfig;
    private String ocrQueue;
    private HttpHostConfigBuilder imageparserConfig;
    private String cvQueue;
    private HttpHostConfigBuilder indexerConfig;
    private HttpHostConfigBuilder searchConfig;
    private Tvm2ClientConfigBuilder tvm2ClientConfig;
    private String apeTvmClientId;
    private String unistorageTvmClientId;
    private HttpTargetConfigBuilder ocrCallbacksConfig;
    private String ocrCallbacksQueue;
    private HttpTargetConfigBuilder cvCallbacksConfig;
    private HttpTargetConfigBuilder faceCallbacksConfig;
    private String cvCallbacksQueue;
    private String faceCallbacksQueue;
    private boolean usePreviewStid;

    protected AbstractOcrProxyConfigBuilder(final OcrProxyConfig config) {
        super(config);
        ocraasConfig(config.ocraasConfig());
        ocrQueue(config.ocrQueue());
        imageparserConfig(config.imageparserConfig());
        cvQueue(config.cvQueue());
        indexerConfig(config.indexerConfig());
        searchConfig(config.searchConfig());
        tvm2ClientConfig(config.tvm2ClientConfig());
        apeTvmClientId(config.apeTvmClientId());
        unistorageTvmClientId(config.unistorageTvmClientId());
        ocrCallbacksConfig(config.ocrCallbacksConfig());
        ocrCallbacksQueue(config.ocrCallbacksQueue());
        cvCallbacksConfig(config.cvCallbacksConfig());
        cvCallbacksQueue(config.cvCallbacksQueue());
        cvCallbacksConfig(config.faceCallbacksConfig());
        cvCallbacksQueue(config.faceCallbacksQueue());
        usePreviewStid(config.usePreviewStid());
    }

    protected AbstractOcrProxyConfigBuilder(
        final IniConfig config,
        final OcrProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig ocraas = config.section("ocraas");
        ocraasConfig =
            new HttpHostConfigBuilder(ocraas, defaults.ocraasConfig());
        ocrQueue = QUEUE.extract(ocraas, defaults.ocrQueue());
        usePreviewStid =
            config.getBoolean("use-preview-stid", defaults.usePreviewStid());

        IniConfig imageparser = config.section("imageparser");
        imageparserConfig = new HttpHostConfigBuilder(
            imageparser,
            defaults.imageparserConfig());
        cvQueue = QUEUE.extract(imageparser, defaults.cvQueue());
        indexerConfig = new HttpHostConfigBuilder(
            config.section("indexer"),
            defaults.indexerConfig());
        searchConfig = new HttpHostConfigBuilder(
            config.section("search"),
            defaults.searchConfig());
        tvm2ClientConfig = new Tvm2ClientConfigBuilder(
            config.section("tvm2"),
            defaults.tvm2ClientConfig());

        apeTvmClientId =
            APE_TVM_CLIENT_ID.extract(config, defaults.apeTvmClientId());
        unistorageTvmClientId = UNISTORAGE_TVM_CLIENT_ID.extract(
            config,
            defaults.unistorageTvmClientId());

        IniConfig ocrCallbacksSection = config.section("ocr-callbacks");
        ocrCallbacksConfig = new HttpTargetConfigBuilder(
            ocrCallbacksSection,
            defaults.ocrCallbacksConfig());
        ocrCallbacksQueue = QUEUE.extract(
            ocrCallbacksSection,
            defaults.ocrCallbacksQueue());
        IniConfig cvCallbacksSection = config.section("cv-callbacks");
        cvCallbacksConfig = new HttpTargetConfigBuilder(
            cvCallbacksSection,
            defaults.cvCallbacksConfig());
        cvCallbacksQueue = QUEUE.extract(
            cvCallbacksSection,
            defaults.cvCallbacksQueue());
        IniConfig faceCallbacksSection = config.section("face-callbacks");
        faceCallbacksConfig = new HttpTargetConfigBuilder(
            faceCallbacksSection,
            defaults.faceCallbacksConfig());
        faceCallbacksQueue = QUEUE.extract(
            faceCallbacksSection,
            defaults.faceCallbacksQueue());
    }

    @Override
    public HttpHostConfigBuilder ocraasConfig() {
        return ocraasConfig;
    }

    public T ocraasConfig(final HttpHostConfig ocraasConfig) {
        this.ocraasConfig = new HttpHostConfigBuilder(ocraasConfig);
        return self();
    }

    @Override
    public String ocrQueue() {
        return ocrQueue;
    }

    public T ocrQueue(final String ocrQueue) {
        this.ocrQueue = ocrQueue;
        return self();
    }

    @Override
    public HttpHostConfigBuilder imageparserConfig() {
        return imageparserConfig;
    }

    public T imageparserConfig(final HttpHostConfig imageparserConfig) {
        this.imageparserConfig = new HttpHostConfigBuilder(imageparserConfig);
        return self();
    }

    @Override
    public String cvQueue() {
        return cvQueue;
    }

    public T cvQueue(final String cvQueue) {
        this.cvQueue = cvQueue;
        return self();
    }

    @Override
    public HttpHostConfigBuilder indexerConfig() {
        return indexerConfig;
    }

    public T indexerConfig(final HttpHostConfig indexerConfig) {
        this.indexerConfig = new HttpHostConfigBuilder(indexerConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder searchConfig() {
        return searchConfig;
    }

    public T searchConfig(final HttpHostConfig searchConfig) {
        this.searchConfig = new HttpHostConfigBuilder(searchConfig);
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    public T tvm2ClientConfig(final Tvm2ClientConfig tvm2ClientConfig) {
        this.tvm2ClientConfig = new Tvm2ClientConfigBuilder(tvm2ClientConfig);
        return self();
    }

    @Override
    public String apeTvmClientId() {
        return apeTvmClientId;
    }

    public T apeTvmClientId(final String apeTvmClientId) {
        this.apeTvmClientId = apeTvmClientId;
        return self();
    }

    @Override
    public String unistorageTvmClientId() {
        return unistorageTvmClientId;
    }

    public T unistorageTvmClientId(final String unistorageTvmClientId) {
        this.unistorageTvmClientId = unistorageTvmClientId;
        return self();
    }

    @Override
    public HttpTargetConfigBuilder ocrCallbacksConfig() {
        return ocrCallbacksConfig;
    }

    public T ocrCallbacksConfig(final HttpTargetConfig ocrCallbacksConfig) {
        this.ocrCallbacksConfig = new HttpTargetConfigBuilder(
            ocrCallbacksConfig);
        return self();
    }

    @Override
    public String ocrCallbacksQueue() {
        return ocrCallbacksQueue;
    }

    public T ocrCallbacksQueue(final String ocrCallbacksQueue) {
        this.ocrCallbacksQueue = ocrCallbacksQueue;
        return self();
    }

    @Override
    public HttpTargetConfigBuilder cvCallbacksConfig() {
        return cvCallbacksConfig;
    }

    public T cvCallbacksConfig(final HttpTargetConfig cvCallbacksConfig) {
        this.cvCallbacksConfig = new HttpTargetConfigBuilder(
            cvCallbacksConfig);
        return self();
    }

    @Override
    public String cvCallbacksQueue() {
        return cvCallbacksQueue;
    }

    public T cvCallbacksQueue(final String cvCallbacksQueue) {
        this.cvCallbacksQueue = cvCallbacksQueue;
        return self();
    }

    @Override
    public HttpTargetConfigBuilder faceCallbacksConfig() {
        return faceCallbacksConfig;
    }

    public T faceCallbacksConfig(
        final HttpTargetConfig faceCallbacksConfig)
    {
        this.faceCallbacksConfig = new HttpTargetConfigBuilder(faceCallbacksConfig);
        return self();
    }

    @Override
    public String faceCallbacksQueue() {
        return faceCallbacksQueue;
    }

    public T faceCallbacksQueue(final String faceCallbacksQueue) {
        this.faceCallbacksQueue = faceCallbacksQueue;
        return self();
    }

    @Override
    public boolean usePreviewStid() {
        return usePreviewStid;
    }

    public T usePreviewStid(final boolean usePreviewStid) {
        this.usePreviewStid = usePreviewStid;
        return self();
    }

    public void copyTo(final AbstractOcrProxyConfigBuilder<?> other) {
        copyTo((AbstractHttpProxyConfigBuilder<?>) other);
        other.ocraasConfig(ocraasConfig);
        other.ocrQueue(ocrQueue);
        other.imageparserConfig(imageparserConfig);
        other.cvQueue(cvQueue);
        other.indexerConfig(indexerConfig);
        other.ocrCallbacksConfig(ocrCallbacksConfig);
        other.ocrCallbacksQueue(ocrCallbacksQueue);
        other.cvCallbacksConfig(cvCallbacksConfig);
        other.cvCallbacksQueue(cvCallbacksQueue);
        other.faceCallbacksConfig(faceCallbacksConfig);
        other.faceCallbacksQueue(faceCallbacksQueue);
    }
}

