package ru.yandex.ocr.proxy;

import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class CvStater implements Stater {
    private final Iterable<CvStat> data;

    public CvStater(final Iterable<CvStat> data) {
        this.data = data;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        int count = 0;
        int unsupported = 0;
        int notFound = 0;
        int locked = 0;
        int tooLarge = 0;
        int error = 0;
        int results = 0;
        int i2t = 0;
        int i2tEmpty = 0;
        int faces = 0;
        int facesEmpty = 0;
        int classes = 0;
        int classesEmpty = 0;
        long maxLag = 0L;
        for (CvStat stat: data) {
            ++count;
            if (stat.error()) {
                ++error;
            } else if (stat.tooLarge()) {
                ++tooLarge;
            } else if (stat.notFound()) {
                ++notFound;
            } else if (stat.locked()) {
                ++locked;
            } else if (stat.unsupported()) {
                ++unsupported;
            } else {
                ++results;
                if (stat.hasI2T()) {
                    ++i2t;
                } else {
                    ++i2tEmpty;
                }
                if (stat.hasFaces()) {
                    ++faces;
                } else {
                    ++facesEmpty;
                }
                if (stat.hasClasses()) {
                    ++classes;
                } else {
                    ++classesEmpty;
                }
            }
            long lag = stat.lag();
            if (lag > maxLag) {
                maxLag = lag;
            }
        }
        statsConsumer.stat("cv-lag_axxx", maxLag);
        statsConsumer.stat("cv-processed_ammm", count);
        statsConsumer.stat("cv-errors_ammm", error);
        statsConsumer.stat("cv-too-large_ammm", tooLarge);
        statsConsumer.stat("cv-unsupported_ammm", unsupported);
        statsConsumer.stat("cv-not-found_ammm", notFound);
        statsConsumer.stat("cv-locked_ammm", locked);
        statsConsumer.stat("cv-i2t-empty_ammm", i2tEmpty);
        statsConsumer.stat("cv-i2t-non-empty_ammm", i2t);
        statsConsumer.stat("cv-faces-empty_ammm", facesEmpty);
        statsConsumer.stat("cv-faces-non-empty_ammm", faces);
        statsConsumer.stat("cv-classes-empty_ammm", classesEmpty);
        statsConsumer.stat("cv-classes-non-empty_ammm", classes);
        statsConsumer.stat("cv-successful_ammm", results);
    }
}

