package ru.yandex.ocr.proxy;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableOcrProxyConfig
    extends ImmutableHttpProxyConfig
    implements OcrProxyConfig
{
    private final ImmutableHttpHostConfig ocraasConfig;
    private final String ocrQueue;
    private final ImmutableHttpHostConfig imageparserConfig;
    private final String cvQueue;
    private final ImmutableHttpHostConfig indexerConfig;
    private final ImmutableHttpHostConfig searchConfig;
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    private final String apeTvmClientId;
    private final String unistorageTvmClientId;
    private final ImmutableHttpTargetConfig ocrCallbacksConfig;
    private final String ocrCallbacksQueue;
    private final ImmutableHttpTargetConfig cvCallbacksConfig;
    private final String cvCallbacksQueue;
    private final ImmutableHttpTargetConfig faceCallbacksConfig;
    private final String faceCallbacksQueue;
    private final boolean usePreviewStid;

    public ImmutableOcrProxyConfig(final OcrProxyConfig config)
        throws ConfigException
    {
        super(config);
        ocraasConfig = new ImmutableHttpHostConfig(config.ocraasConfig());
        ocrQueue = QUEUE.validate(config.ocrQueue());
        imageparserConfig =
            new ImmutableHttpHostConfig(config.imageparserConfig());
        cvQueue = QUEUE.validate(config.cvQueue());
        indexerConfig = new ImmutableHttpHostConfig(config.indexerConfig());
        searchConfig = new ImmutableHttpHostConfig(config.searchConfig());
        tvm2ClientConfig =
            new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());
        apeTvmClientId = APE_TVM_CLIENT_ID.validate(config.apeTvmClientId());
        unistorageTvmClientId =
            UNISTORAGE_TVM_CLIENT_ID.validate(config.unistorageTvmClientId());
        ocrCallbacksConfig =
            new ImmutableHttpTargetConfig(config.ocrCallbacksConfig());
        ocrCallbacksQueue = QUEUE.validate(config.ocrCallbacksQueue());
        cvCallbacksConfig =
            new ImmutableHttpTargetConfig(config.cvCallbacksConfig());
        cvCallbacksQueue = QUEUE.validate(config.cvCallbacksQueue());
        faceCallbacksConfig =
            new ImmutableHttpTargetConfig(config.faceCallbacksConfig());
        faceCallbacksQueue = QUEUE.validate(config.faceCallbacksQueue());
        usePreviewStid = config.usePreviewStid();
    }

    @Override
    public ImmutableHttpHostConfig ocraasConfig() {
        return ocraasConfig;
    }

    @Override
    public String ocrQueue() {
        return ocrQueue;
    }

    @Override
    public ImmutableHttpHostConfig imageparserConfig() {
        return imageparserConfig;
    }

    @Override
    public String cvQueue() {
        return cvQueue;
    }

    @Override
    public ImmutableHttpHostConfig indexerConfig() {
        return indexerConfig;
    }

    @Override
    public ImmutableHttpHostConfig searchConfig() {
        return searchConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Override
    public String apeTvmClientId() {
        return apeTvmClientId;
    }

    @Override
    public String unistorageTvmClientId() {
        return unistorageTvmClientId;
    }

    @Override
    public ImmutableHttpTargetConfig ocrCallbacksConfig() {
        return ocrCallbacksConfig;
    }

    @Override
    public String ocrCallbacksQueue() {
        return ocrCallbacksQueue;
    }

    @Override
    public ImmutableHttpTargetConfig cvCallbacksConfig() {
        return cvCallbacksConfig;
    }

    @Override
    public String cvCallbacksQueue() {
        return cvCallbacksQueue;
    }

    @Override
    public boolean usePreviewStid() {
        return usePreviewStid;
    }

    @Override
    public ImmutableHttpTargetConfig faceCallbacksConfig() {
        return faceCallbacksConfig;
    }

    @Override
    public String faceCallbacksQueue() {
        return faceCallbacksQueue;
    }
}

