package ru.yandex.ocr.proxy;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.NonEmptyValidator;

public interface OcrProxyConfig extends HttpProxyConfig {
    ParameterConfig<String> QUEUE = new ParameterConfig<>(
        "queue",
        x -> x,
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> APE_TVM_CLIENT_ID = new ParameterConfig<>(
        "server.ape-client-id",
        x -> x,
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> UNISTORAGE_TVM_CLIENT_ID = new ParameterConfig<>(
        "server.unistorage-client-id",
        x -> x,
        NonEmptyValidator.INSTANCE);

    HttpHostConfig ocraasConfig();

    String ocrQueue();

    HttpHostConfig imageparserConfig();

    String cvQueue();

    HttpHostConfig indexerConfig();

    HttpHostConfig searchConfig();

    Tvm2ClientConfig tvm2ClientConfig();

    String apeTvmClientId();

    String unistorageTvmClientId();

    HttpTargetConfig ocrCallbacksConfig();

    String ocrCallbacksQueue();

    HttpTargetConfig cvCallbacksConfig();

    HttpTargetConfig faceCallbacksConfig();

    String cvCallbacksQueue();

    String faceCallbacksQueue();

    boolean usePreviewStid();
}

