package ru.yandex.ocr.proxy;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class OcrProxyConfigBuilder
    extends AbstractOcrProxyConfigBuilder<OcrProxyConfigBuilder>
{
    public OcrProxyConfigBuilder() {
        super(OcrProxyConfigDefaults.INSTANCE);
    }

    public OcrProxyConfigBuilder(final OcrProxyConfig config) {
        super(config);
    }

    public OcrProxyConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, OcrProxyConfigDefaults.INSTANCE);
    }

    public OcrProxyConfigBuilder(
        final IniConfig config,
        final OcrProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public OcrProxyConfigBuilder self() {
        return this;
    }

    public ImmutableOcrProxyConfig build() throws ConfigException {
        return new ImmutableOcrProxyConfig(this);
    }
}

