package ru.yandex.ocr.proxy;

import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class OcrStater implements Stater {
    private final Iterable<OcrStat> data;

    public OcrStater(final Iterable<OcrStat> data) {
        this.data = data;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        int count = 0;
        int error = 0;
        int tooLarge = 0;
        int notFound = 0;
        int locked = 0;
        int unsupported = 0;
        int empty = 0;
        int nonEmpty = 0;
        int preview = 0;
        long maxLag = 0L;
        for (OcrStat stat: data) {
            ++count;
            if (stat.error()) {
                ++error;
            } else if (stat.tooLarge()) {
                ++tooLarge;
            } else if (stat.notFound()) {
                ++notFound;
            } else if (stat.locked()) {
                ++locked;
            } else if (stat.unsupported()) {
                ++unsupported;
            } else if (stat.ocrTextLength() == 0) {
                ++empty;
            } else {
                ++nonEmpty;
            }
            if (stat.preview()) {
                preview += 1;
            }
            long lag = stat.lag();
            if (lag > maxLag) {
                maxLag = lag;
            }
        }
        statsConsumer.stat("ocr-proxy-lag_axxx", maxLag);
        statsConsumer.stat("ocr-proxy-preview-used_ammm", preview);
        statsConsumer.stat("images-processed_ammm", count);
        statsConsumer.stat("ocraas-errors_ammm", error);
        statsConsumer.stat("ocraas-too-large_ammm", tooLarge);
        statsConsumer.stat("ocraas-unsupported_ammm", unsupported);
        statsConsumer.stat("ocraas-not-found_ammm", notFound);
        statsConsumer.stat("ocraas-locked_ammm", locked);
        statsConsumer.stat("ocraas-empty_ammm", empty);
        statsConsumer.stat("ocraas-non-empty_ammm", nonEmpty);
    }
}

