package ru.yandex.search.disk.proxy;

import java.io.IOException;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;

public abstract class AbstractDiskResultPrinter
    extends AbstractProxySessionCallback<SearchResult>
{
    protected final SearchInfo searchInfo;
    protected final JsonType jsonType;

    protected AbstractDiskResultPrinter(
        final ProxySession session,
        final SearchInfo searchInfo)
        throws BadRequestException
    {
        super(session);
        this.searchInfo = searchInfo;
        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
    }

    protected abstract void writeSerp(
        final JsonWriter writer,
        final SearchResult searchResult)
        throws IOException;

    @Override
    public void completed(final SearchResult searchResult) {
        session.connection().setHitsCount(
            Long.toString(searchResult.hitsCount()));
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = jsonType.create(sbw)) {
            writeSerp(writer, searchResult);
        } catch (IOException e) {
            failed(new ServiceUnavailableException(e));
            return;
        }
        session.response(
            HttpStatus.SC_OK,
            new NStringEntity(
                sbw.toString(),
                ContentType.APPLICATION_JSON
                    .withCharset(session.acceptedCharset())));
    }
}

