package ru.yandex.search.disk.proxy;

import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.RequestParams;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchService;

public abstract class AbstractDiskSearchService<P extends RequestParams>
    implements SearchService<SearchResult, P, SearchInfo>
{
    protected final User user;
    protected final List<HttpHost> hosts;

    protected AbstractDiskSearchService(
        final User user,
        final List<HttpHost> hosts)
    {
        this.user = user;
        this.hosts = hosts;
    }

    @Override
    public SearchInfo createSearchInfo(
        final ProxySession session,
        final P requestParams)
    {
        return new SearchInfo(session.params().getString("text", ""));
    }
}

