package ru.yandex.search.disk.proxy;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.PrefixType;

public abstract class AbstractUidProxyHandler implements ProxyHandler {
    protected final Proxy proxy;
    protected final String serviceName;
    protected final PrefixType prefixType;

    protected AbstractUidProxyHandler(
        final Proxy proxy,
        final String serviceName)
    {
        this.proxy = proxy;
        this.serviceName = serviceName;
        prefixType = proxy.searchMap().prefixType(serviceName);
    }

    @Override
    public String serviceName() {
        return serviceName;
    }

    @Override
    public User user(final ProxySession session) throws HttpException {
        return new User(serviceName, session.params().get("uid", prefixType));
    }
}

