package ru.yandex.search.disk.proxy;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpHost;

import ru.yandex.disk.search.DiskField;
import ru.yandex.disk.search.DiskParams;
import ru.yandex.http.proxy.HttpEntitySendingCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.NByteArrayEntityAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.prefix.Prefix;

public class ClusterizeHandler extends AbstractUidProxyHandler {
    private static final String GET = "get";
    private static final String MIN_CLUSTER = "min-cluster";
    private static final String INTERVAL = "interval";
    private static final String LOCAL_INTERVAL = "local-interval";
    private static final String POSTFILTER = "postfilter";
    private static final Set<Prefix> ETIME_HEIC_CREATED
        = new LinkedHashSet<>(Arrays.asList(new LongPrefix(122625849L), new LongPrefix(229876270L), new LongPrefix(10761L)));

    public ClusterizeHandler(final Proxy proxy) {
        super(proxy, proxy.photosliceService());
    }

    @Override
    public void handle(
        final ProxySession session,
        final User user,
        final List<HttpHost> hosts)
        throws HttpException
    {
        QueryConstructor query = new QueryConstructor(proxy.clusterizeQuery());
        query.append("prefix", user.prefix().toString());
        if (ETIME_HEIC_CREATED.contains(user.prefix())) {
            session.logger().info("User in etime_heic_created experiment");
            query.append("dp", "fallback(etime,created,ctime,modified,mtime date)");
        } else {
            query.append("dp", "fallback(etime,ctime,mtime date)");
        }

        query.append("date-field", "date");

        String get = session.params().getString(GET, "id,key,date");
        query.append(GET, get);
        query.append(INTERVAL, session.params().getString(INTERVAL, "7200"));
        query.append(
            LOCAL_INTERVAL,
            session.params().getString(LOCAL_INTERVAL, "14400"));
        query.append(
            MIN_CLUSTER,
            session.params().getString(MIN_CLUSTER, "1"));
        query.copyIfPresent(session.params(), "online");
        query.copyIfPresent(session.params(), "hr");
        query.copyIfPresent(session.params(), "json-type");
        if (session.params().getBoolean("skip-nulls", true)) {
            query.sb().append("&skip-nulls");
        }
        for (String postfilter: session.params().getAll(POSTFILTER)) {
            query.append(POSTFILTER, postfilter);
        }

        session.logger().info(session.params().toString());
        if (session.params().getBoolean(DiskParams.FAST_MOVED, false)
            && get.contains(DiskField.FILE_KEY.fieldName()))
        {
//            if (user.shard() < EXPERIMENT_MAX_REVISION) {
//
//
//            } else {
//                session.logger().info("Fast moved");
//                Proxy.addFastMovedDp(query);
//            }
            session.logger().info("Experiment, fast revision");
            query.append(
                "dp",
                "tree_root_rev(parent_fid,fid,type:dir,disk_concat(/),"
                    + "name,version key,max_version)");
            query.append(
                "disk-allowed-roots",
                Proxy.DISK_ALLOWED_ROOTS);
        }

        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(query.toString());
        producerGenerator.copyHeader(
            session.request(),
            HttpHeaders.ACCEPT_CHARSET);
        producerGenerator.copyHeader(
            session.request(),
            HttpHeaders.ACCEPT_ENCODING);
        AsyncClient client =
            proxy.photosliceClient().adjust(session.context());
        session.subscribeForCancellation(
                client.execute(
                        hosts,
                        producerGenerator,
                        NByteArrayEntityAsyncConsumerFactory.OK,
                        session.listener().createContextGeneratorFor(client),
                        new HttpEntitySendingCallback(session)));
    }

    @Override
    public String toString() {
        return "https://wiki.yandex-team.ru/disk/mpfs/RD/PhotoBabylon"
            + "#vnutrennijjapiklasterizatora";
    }
}

