package ru.yandex.search.disk.proxy;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpHost;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeIntegerValidator;
import ru.yandex.search.rules.RequestParams;

public class DiskRequestParams implements RequestParams {
    public static final int DEFAULT_LENGTH = 40;

    private static final CollectionParser<String, Set<String>, Exception>
        ONLY_PARSER = new CollectionParser<>(
            NonEmptyValidator.INSTANCE,
            LinkedHashSet::new);
    private static final CollectionParser<String, Set<String>, Exception>
        EXTENSIONS_PARSER = new CollectionParser<>(
        NonEmptyValidator.INSTANCE,
        LinkedHashSet::new);

    private final User user;
    private final List<HttpHost> hosts;
    private final int offset;
    private final int length;
    private final Set<String> fields;
    private final boolean asc;
    private final Set<String> fileExtensions;

    public DiskRequestParams(
        final ProxySession session,
        final User user,
        final List<HttpHost> hosts)
        throws BadRequestException
    {
        this.user = user;
        this.hosts = hosts;
        int numdoc = session.params().get(
            "numdoc",
            -1,
            NonNegativeIntegerValidator.INSTANCE);
        if (numdoc == -1) {
            length = session.params().get(
                "amount",
                DEFAULT_LENGTH,
                NonNegativeIntegerValidator.INSTANCE);
        } else {
            length = numdoc;
        }
        int page = session.params().get(
            "p",
            -1,
            NonNegativeIntegerValidator.INSTANCE);
        if (page == -1) {
            offset = session.params().get(
                "offset",
                0,
                NonNegativeIntegerValidator.INSTANCE);
        } else {
            offset = page * length;
        }
        fields = session.params().get("only", ONLY_PARSER);
        asc = session.params().getBoolean("asc", false);
        fileExtensions =
            session.params().get(
                "extension",
                Collections.emptySet(),
                EXTENSIONS_PARSER);
    }

    @Override
    public int offset() {
        return offset;
    }

    @Override
    public int length() {
        return length;
    }

    @Override
    public Set<String> fields() {
        return fields;
    }

    public User user() {
        return user;
    }

    public List<HttpHost> hosts() {
        return hosts;
    }

    public boolean asc() {
        return asc;
    }

    public Set<String> fileExtensions() {
        return fileExtensions;
    }
}

