package ru.yandex.search.disk.proxy;

import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.rules.SearchInfo;

public class DiskSearchService
    extends AbstractDiskSearchService<DiskRequestParams>
{
    private final Proxy proxy;

    public DiskSearchService(
        final Proxy proxy,
        final User user,
        final List<HttpHost> hosts)
    {
        super(user, hosts);
        this.proxy = proxy;
    }

    @Override
    public DiskRequestParams createRequestParams(final ProxySession session)
        throws BadRequestException
    {
        return new DiskRequestParams(session, user, hosts);
    }

    @Override
    public DiskResultPrinter createCallback(
        final ProxySession session,
        final DiskRequestParams requestParams,
        final SearchInfo searchInfo)
        throws BadRequestException
    {
        return new DiskResultPrinter(
            proxy,
            session,
            requestParams,
            searchInfo);
    }
}

