package ru.yandex.search.disk.proxy;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;

import ru.yandex.http.proxy.HttpEntitySendingCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.NByteArrayEntityAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;

public class GetHandler extends AbstractUidProxyHandler {
    private static final long GET_FAILOVER_DELAY = 100;

    public GetHandler(final Proxy proxy) {
        super(proxy, proxy.diskService());
    }

    @Override
    public void handle(
        final ProxySession session,
        final User user,
        final List<HttpHost> hosts)
        throws HttpException
    {
        CgiParams params = session.params();
        boolean offline =
            params.getBoolean("offline", false);
        boolean online = params.getBoolean("online", !offline);
        QueryConstructor query =
            new QueryConstructor("/search-get-attribute?");
        query.append("prefix", user.prefix().toString());

        query.copy(params, "get");
        StringBuilder text = new StringBuilder("id:(");
        List<String> ids =
            params.getAll("id", NonEmptyValidator.INSTANCE, new ArrayList<>());
        for (String id: ids) {
            text.append(id);
            text.append(' ');
        }
        text.setCharAt(text.length() - 1, ')');
        if (params.getBoolean(Proxy.APPLY_PHOTOSLICE_FILTER, false)) {
            text.append(" AND (");
            text.append(proxy.config().imagesFilter());
            text.append(')');
        }
        query.append("text", new String(text));
        if (!online) {
            query.append("IO_PRIO", "10000");
        }
        query.copyIfPresent(params, "hr");
        query.copyIfPresent(params, "json-type");
        query.copyIfPresent(params, "skip-nulls");
        query.copyIfPresent(params, "sort");
        query.copyIfPresent(params, "asc");
        for (String postfilter: params.getAll(Proxy.POSTFILTER)) {
            query.append(Proxy.POSTFILTER, postfilter);
        }

        boolean buildPath = params.getBoolean("build_path", false);
        if (buildPath) {
            Proxy.addFastMovedDp(query);
        }
        AsyncClient client = proxy.searchClient().adjust(session.context());
        client.executeWithDelay(
            hosts,
            new BasicAsyncRequestProducerGenerator(query.toString()),
            GET_FAILOVER_DELAY,
            NByteArrayEntityAsyncConsumerFactory.OK,
            session.listener().createContextGeneratorFor(client),
            new HttpEntitySendingCallback(session));
    }

    @Override
    public String toString() {
        return "Files fields retrieval handler";
    }
}

