package ru.yandex.search.disk.proxy;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.search.disk.proxy.rules.HnswPlainSearchRule;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRule;

public class HnswSearchHandler extends SearchHandler {

    // CSOFF: MethodLength
    public HnswSearchHandler(
            final Proxy proxy,
            final TimeFrameQueue<MultiSearchStat> rulesStats)
    {
        super(proxy, rulesStats);
    }

    @Override
    protected SearchRule<SearchResult, DiskRequestParams, SearchInfo> getInnerDssmSearchRule(Proxy proxy, int seed) {
        return new HnswPlainSearchRule(proxy, seed);
    }

    @Override
    public String toString() {
        return "HNSW Search for user files on Yandex.Disk";
    }
}
