package ru.yandex.search.disk.proxy;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class MultiSearchStater
    extends TimeFrameQueue<MultiSearchStat>
    implements Stater
{
    public MultiSearchStater(final long metricsTimeFrame) {
        super(metricsTimeFrame);
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        long totalTime = 0L;
        int responses = 0;
        Map<String, long[]> rulesTimings = new HashMap<>();
        for (MultiSearchStat stat: this) {
            totalTime += stat.totalTime();
            ++responses;
            for (Map.Entry<String, Long> ruleTiming
                : stat.rulesTimings().entrySet())
            {
                rulesTimings.computeIfAbsent(
                    ruleTiming.getKey(),
                    x -> new long[1])[0] += ruleTiming.getValue().longValue();
            }
        }
        statsConsumer.stat("total-responses-time_ammm", totalTime);
        statsConsumer.stat("responses_ammm", responses);
        for (Map.Entry<String, long[]> ruleTiming: rulesTimings.entrySet()) {
            statsConsumer.stat(
                ruleTiming.getKey() + "-rule-time_ammm",
                ruleTiming.getValue()[0]);
        }
    }
}

