package ru.yandex.search.disk.proxy;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixType;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class PhotosDateRangeHandler implements ProxyRequestHandler {
    public static final String FILTER =
        "&postfilter=height+%3e%3d+800&postfilter=width+%3e%3d+800"
        + "&text=etime:*+AND"
        + "+beautiful:%5B0.08+TO+9999%5D+aux_folder:%28disk+photounlim%29";
    public static final String COORDS_FILTER =
        "&postfilter=latitude+%3e%3d+-180.0"
        + "&postfilter=longitude+%3e%3d+-180.0";

    private static final String ETIME = "etime";

    private final Proxy proxy;
    private final String serviceName;
    private final PrefixType prefixType;

    public PhotosDateRangeHandler(final Proxy proxy) {
        this.proxy = proxy;
        serviceName = proxy.diskService();
        prefixType = proxy.searchMap().prefixType(serviceName);
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        Prefix prefix = session.params().get("uid", prefixType);
        AsyncClient client = proxy.searchClient().adjust(session.context());
        UniversalSearchProxyRequestContext requestContext =
            new PlainUniversalSearchProxyRequestContext(
                new User(serviceName, prefix),
                null,
                true,
                client,
                session.logger());
        QueryConstructor query = new QueryConstructor(
            "/search?json-type=dollar&IO_PRIO=0&get=etime&sort=etime"
            + FILTER + COORDS_FILTER);
        query.append("prefix", prefix.toString());
        query.append("service", serviceName);
        proxy.parallelRequest(
            session,
            requestContext,
            new BasicAsyncRequestProducerGenerator(query.toString()),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            session.listener().createContextGeneratorFor(client),
            new Callback(session));
    }

    private static class Callback
        extends AbstractProxySessionCallback<JsonObject>
    {
        Callback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                JsonList docs = result.get("hitsArray").asList();
                if (docs.isEmpty()) {
                    session.response(HttpStatus.SC_NOT_FOUND);
                } else {
                    session.response(
                        HttpStatus.SC_OK,
                        new NStringEntity(
                            "{\"min-etime\":"
                            + docs.get(docs.size() - 1).get(ETIME).asLong()
                            + ",\"max-etime\":"
                            + docs.get(0).get(ETIME).asLong() + '}',
                            ContentType.APPLICATION_JSON
                                .withCharset(session.acceptedCharset())));
                }
            } catch (JsonException e) {
                failed(e);
            }
        }
    }
}

