package ru.yandex.search.disk.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.parser.searchmap.User;
import ru.yandex.util.string.StringUtils;

public interface PrintkeysWarmable extends Warmable {
    String warmupPostfix();

    @Override
    default List<Function<User, BasicAsyncRequestProducerGenerator>>
        generators()
    {
        StringBuilder baseUri = new StringBuilder("/printkeys-warmup");
        baseUri.append(warmupPostfix());
        baseUri.append("?");
        baseUri.append("&length=40&reverse&warmer");
        baseUri.append("&get=");
        baseUri.append(StringUtils.join(warmUpValueFields(), ','));

        List<Function<User, BasicAsyncRequestProducerGenerator>> result =
            new ArrayList<>();

        for (String key: warmUpKeyFields()) {
            final StringBuilder uri = new StringBuilder(baseUri);
            uri.append("&field=");
            uri.append(key);
            result.add((user) -> {
                StringBuilder sb = new StringBuilder(uri);
                sb.append("&prefix=");
                sb.append(user.prefix());
                sb.append("&service=");
                sb.append(user.service());
                return new BasicAsyncRequestProducerGenerator(
                    sb.toString(),
                    null,
                    RequestHandlerMapper.HEAD);
            });
        }

        return result;
    }

    Set<String> warmUpKeyFields();

    Set<String> warmUpValueFields();
}
