package ru.yandex.search.disk.proxy;

import java.util.Set;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.erratum.ErratumConfig;
import ru.yandex.geocoder.GeocoderConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.URIConfig;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;

public interface ProxyConfig extends UniversalSearchProxyConfig {
    ErratumConfig misspellConfig();

    GeocoderConfig geoSearchConfig();

    HttpHostConfig userSplitConfig();

    HttpHostConfig faceIndexerConfig();

    String imagesFilter();

    String searchPostFilter();

    String diskService();

    String photosliceService();

    String ipddService();

    Set<String> producerServices();

    long fatUserDocs();

    HttpTargetConfig photosliceClientConfig();

    JniWrapperConfig dssmConfig();

    long dssmThreshold();

    URIConfig djfsConfig();

    Tvm2ClientConfig tvm2ClientConfig();

    Long failoverSearchDelay();

    String djfsTvmClientId();

    String geoTvmClientId();
}

